<?php
/**
 * Plugin Name:       Jubelio Shipment HPOS Edition
 * Plugin URI:        https://github.com/jubelio/jubelio-shipment-hpos
 * Description:       Simple and fast WooCommerce plugin with various courier options such as Grab Express, JNE, SiCepat, Paxel, and many more
 * Version:           2.0.0
 * Author:            Jubelio
 * Author URI:        https://github.com/jubelio
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       jubelio-shipment-hpos
 * Domain Path:       /languages
 *
 * WC requires at least: 9.0.0
 * WC tested up to: 9.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * ----------------------------------------------------
 * Constants
 * ----------------------------------------------------
 */
define( 'JUBELIO_SHIPMENT_VERSION', '2.0.0' );
define( 'JUBELIO_SHIPMENT_METHOD_ID', 'jubelioshipment' );
define( 'JUBELIO_SHIPMENT_FILE', __FILE__ );
define( 'JUBELIO_SHIPMENT_PATH', plugin_dir_path( __FILE__ ) );
define( 'JUBELIO_SHIPMENT_URL', plugin_dir_url( __FILE__ ) );
define( 'JUBELIO_SHIPMENT_WC_VERSION', '9.0.0' );

/**
 * ----------------------------------------------------
 * HPOS Compatibility Declaration (MUST BE FIRST)
 * ----------------------------------------------------
 */
add_action( 'before_woocommerce_init', function () {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
            'custom_order_tables',
            __FILE__,
            true
        );
    }
});

/**
 * ----------------------------------------------------
 * Helpers
 * ----------------------------------------------------
 */
require_once JUBELIO_SHIPMENT_PATH . 'includes/helpers.php';

/**
 * ----------------------------------------------------
 * Admin Notices
 * ----------------------------------------------------
 */
function jubelioshipment_woocommerce_inactive_notice() {
    echo '<div class="notice notice-error"><p>';
    esc_html_e( 'Jubelio Shipment requires WooCommerce to be active.', 'jubelio-shipment-hpos' );
    echo '</p></div>';
}

function jubelioshipment_woocommerce_version_notice() {
    echo '<div class="notice notice-error"><p>';
    printf(
        esc_html__( 'Jubelio Shipment requires WooCommerce version %s or higher.', 'jubelio-shipment-hpos' ),
        esc_html( JUBELIO_SHIPMENT_WC_VERSION )
    );
    echo '</p></div>';
}

/**
 * ----------------------------------------------------
 * Activation Check (NO WC() CALLS)
 * ----------------------------------------------------
 */
function jubelioshipment_activation_check() {

    if ( ! class_exists( 'WooCommerce' ) ) {
        deactivate_plugins( plugin_basename( __FILE__ ) );
        wp_die(
            esc_html__( 'Jubelio Shipment requires WooCommerce to be active.', 'jubelio-shipment-hpos' ),
            'Plugin Activation Error',
            array( 'back_link' => true )
        );
    }

    if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, JUBELIO_SHIPMENT_WC_VERSION, '<' ) ) {
        deactivate_plugins( plugin_basename( __FILE__ ) );
        wp_die(
            sprintf(
                esc_html__( 'Jubelio Shipment requires WooCommerce version %s or higher.', 'jubelio-shipment-hpos' ),
                esc_html( JUBELIO_SHIPMENT_WC_VERSION )
            ),
            'Plugin Activation Error',
            array( 'back_link' => true )
        );
    }
}
register_activation_hook( __FILE__, 'jubelioshipment_activation_check' );

/**
 * ----------------------------------------------------
 * Phase 1: Minimal WC Presence Check
 * ----------------------------------------------------
 */
add_action( 'plugins_loaded', function () {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', 'jubelioshipment_woocommerce_inactive_notice' );
    }
});

/**
 * ----------------------------------------------------
 * Phase 2: REAL Plugin Init (HPOS READY)
 * ----------------------------------------------------
 */
add_action( 'woocommerce_init', 'jubelioshipment_init' );

function jubelioshipment_init() {

    if ( ! defined( 'WC_VERSION' ) || version_compare( WC_VERSION, JUBELIO_SHIPMENT_WC_VERSION, '<' ) ) {
        add_action( 'admin_notices', 'jubelioshipment_woocommerce_version_notice' );
        return;
    }

    if ( function_exists( 'jubelioshipment_autoload' ) ) {
        spl_autoload_register( 'jubelioshipment_autoload' );
    }

    if ( class_exists( 'JubelioShipment' ) ) {
        JubelioShipment::get_instance();
    }
}
